
###################################################################################
###################################################################################

#Cross Validation to choose the truncation lag

#Input: 
#n: number of obs; 
#ncall: number of calls, ordered first in the sample;
#P: option prices, the first ncall values are call prices;
#k: the transformed call and put strikes, in the same order as the option prices; 
#tau: time to expiration; 
#st: spot stock price; 
#Sigma: the implied vol;
#alphaR: candidate values; 
#DegreeVec: degree of polynomial; 
#x: support of density

CV.j<-function(nFold,n,ncall,P,k,tau,st,Sigma,DegreeVec,x,Ncores,negtol=-0.001)

{
Num<-length(DegreeVec)
m<-length(x)


trainfold <- kfold(n, nFold )$a
testfold <- kfold(n, nFold)$b


# randomize the data to do CV
Nrandom = sample(1:n)

# fx matrix
fx <- matrix( rep(0, Num*m), nrow=Num)

# mean squared pricing error vector
MSE_vec <- rep(NA, Num)

# pricing error matrix
PricingErr <- matrix( rep(0, n*Num ) , nrow=n )

# phi is the weighting function for Hermite Polys
phi <- exp(-x^2 / 2)





##################################################################
# paral func to do the CV
ParalFunc <- function(ii) {
  
  tryCatch({
    
    for (j in 1:nFold) {
      
      PtrainInd = Nrandom[ trainfold[[j]] ]
      PtestInd  = Nrandom[ testfold[[j]]  ]
      ktrainInd = Nrandom[ trainfold[[j]] ]
      ktestInd  = Nrandom[ testfold[[j]]  ]
      
      Ptrain <- P[PtrainInd]
      Ptest <-  P[PtestInd]
      ktrain <- k[ktrainInd]
      ktest <-  k[ktestInd]
      ntrain <- length(Ptrain)
      ntest <- length(Ptest)
      
      # degree of hermite polynomials
      degree <- DegreeVec[ii]
      
      ############################################################################
      ########### the minimization problem is to  
      #     min    P - R * [beta]'  
      #     st      A * [beta]' > b
      
      
      
      
      # poly.list indicates which polynomials to use
      poly.list <- hermite.h.polynomials(degree, normalized=F )
      
      
      # Tx is the matrix of basis functions 
      # Ts is the orthonomal basis
      Tx <- do.call(rbind, polynomial.values(poly.list, x))
      
      Ts <- sweep(Tx, MARGIN=2, phi, '*')
      for(i in 0:degree)
      {
        Ts[i+1,] = (2^i * factorial(i) * sqrt(pi))^(-0.5) * Ts[i+1,]
      }
      
      
      htemp <- x[2:length(x)]-x[1:(length(x)-1)]
      ci <- 0.5*htemp[1:(length(htemp)-1)] + 0.5*htemp[2:length(htemp)]
      ci <- c(htemp[1], ci, htemp[length(htemp)])
      m <- length(ci)
      rm(htemp)
      
      
      # some relavant parameters 
      # ci is the integrand coefficients
      
      
      # ci matrix
      Ci <- matrix(rep(ci, ntrain), nrow=ntrain, byrow=TRUE)
      
     
      
      # g is matrix of payoff
      g <- matrix(rep(1, ntrain*m),  nrow=ntrain, byrow=TRUE)  
      
      for (i in 1:ntrain ) 
      {
        if (PtrainInd[i] <= ncall)
        {
          temp <- st * ( exp(sqrt(tau)*Sigma*x) - 
                           exp(sqrt(tau)*Sigma*ktrain[i]) )
        }
        else if (PtrainInd[i] > ncall)
        {
          temp <- st * ( exp(sqrt(tau)*Sigma*ktrain[i]) - 
                           exp(sqrt(tau)*Sigma*x) )
        }
        
        temp[temp<0] = 0
        g[i,] <- temp
        rm(temp)
      }
      
      G <- g * Ci 
      
      # R is the matrix of "regressors"
      R = G %*% t(Ts)
      
      
      
      ########################################
      ########################################
      
      # optimization using QUADPROG package
        #penalization
        alpha <- 0
        method <-1
        
      # include alpha identity matrix
      if (method==1){
        # quadratic coeff in the obj
        alphaI <- alpha * diag(degree+1)
         Fmat <- 2* ( t(R) %*% R + alphaI)
        }
        else{
          tempMat <- t(R)%*%R #/ nrow(R) #nrow dropped
          Vmat <- eigen(tempMat)$vectors   # eigen vecotr matrix
          Vlambda <- eigen(tempMat)$values # eigen values 
      
          # construct the Q-alpha diagonal matrix
            Dalpha <- diag( alpha - Vlambda )
            Dalpha[Dalpha<0] <- 0
            Qalpha <- Vmat %*% ( Dalpha %*% t(Vmat) )
            # quadratic coeff in the obj
           Fmat <- 2* ( t(R) %*% R + Qalpha)
        }
      
      # linear coeff in the obj
      f <- 2* (t(Ptrain) %*% R)
      
      # equality constraints matrix
      A1 <- ci %*% t(Ts)
      
      # inequality constraints matrix
      A2 <- t(Ts)
      
      # combine into 1 matrix
      A <- rbind(A1, A2)
      A <- t(A2)
      
      # values of the constraints
      #b <- c( 1, -1*rep(10,m) )
      b <- c( negtol*rep(1,m) )
      
      # specify the number of equalities
     
      neq <-0
      
      # solve
      prob <- solve.QP(Fmat, f, A, b, neq)
      beta <- prob$solution[1:(degree+1)]
      
      
      # Phat is predicted price
      Phat <- numeric(ntest)
      
      # calulate the pricing error
      for (i in 1:ntest ) 
      {
        if (PtestInd[i] <= ncall)
        {
          temp <- st * ( exp(sqrt(tau)*Sigma*x) - 
                           exp(sqrt(tau)*Sigma*ktest[i]) )
        }
        else if (PtestInd[i] > ncall)
        {
          temp <- st * ( exp(sqrt(tau)*Sigma*ktest[i]) - 
                           exp(sqrt(tau)*Sigma*x) )
        }
        
        temp[temp<0] <- 0
        Phat <- (ci*temp) %*% t(Ts) %*% beta
        PricingErr[ktestInd[i],ii] <- (Ptest[i]-Phat)^2
        rm(temp)
      }
      
    }
    
    MSE_vec[ii] <- mean(PricingErr[,ii])
    return( list(a=MSE_vec[ii]) )
    
  }, error = function(err) return(NA))
  
}


values <- 1:Num
result <- mclapply(values, ParalFunc, mc.cores=Ncores)

print(result)

for (i in 1:Num){
  if (!is.na(result[[i]])){
    MSE_vec[i] <- result[[i]]$a
  }
}

if (!is.na(min(MSE_vec, na.rm=T))){
  ind <- which(MSE_vec == min(MSE_vec, na.rm=T),
               arr.ind = TRUE)
}

if (length(ind)==0){
  ind<-1
}


bestDegree <- DegreeVec[ind]
#bestAlphaR	<-	bestAlphaR[1] #in case there is a tie


return(list(bestDegree=bestDegree,ind=ind,MSE_vec))

}
